<?php

namespace App\Http\Middleware;

use App\Libraries\Utils;
use Closure;
use \Auth;

class CustomerAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (Auth::check()) {
            if (Utils::isCustomer(Auth::user()->id)) {
                return $next($request);
            } else {

                if (Utils::isAdmin(Auth::user()->id)) {
                    return redirect()->to('/admin');
                }

                if (Utils::isPublisher(Auth::user()->id)) {
                    return redirect()->to('/publisher');
                }

            }
        } else {
            return redirect()->to('/login');
        }
    }
}
